/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.parts;

import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.internal.action.PluginDownload;
import de.willuhn.jameica.gui.internal.action.PluginUnInstall;
import de.willuhn.jameica.gui.internal.action.PluginUpdate;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.InfoPanel;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.messaging.PluginCacheMessageConsumer;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.plugin.Version;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.update.PluginData;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PluginDetailPart
extends InfoPanel {
    private static final I18N i18n = Application.getI18n();
    private SelectInput version = null;
    private List<PluginData> plugins = null;
    private Manifest manifest = null;
    private Type type = null;

    public PluginDetailPart(Manifest mf, Type type) {
        this(mf, null, type);
    }

    public PluginDetailPart(Manifest mf, List<PluginData> plugins, Type type) {
        this.plugins = plugins;
        this.manifest = mf;
        this.type = type;
        this.setUrl(this.manifest.getHomepage());
        this.setBorder(Boolean.TRUE);
        String icon = this.manifest.getIcon();
        if (icon == null || type != null && type == Type.AVAILABLE) {
            icon = "package-x-generic-medium.png";
        }
        this.setIcon(icon);
        this.setText(this.manifest.getDescription());
        if (this.type == Type.INSTALLED && !this.manifest.isInstalled()) {
            this.setForeground(Color.COMMENT);
        }
        Throwable error = Application.getPluginLoader().getInitErrors().get(this.manifest);
        String title = this.manifest.getName();
        if (!this.manifest.isInstalled() && this.type == Type.INSTALLED) {
            String text = "";
            text = error != null ? error.getMessage() : (PluginCacheMessageConsumer.getCache().containsKey(mf.getName()) ? i18n.tr("Neustart erforderlich") : i18n.tr("Nicht installiert"));
            title = i18n.tr("{0} ({1})", new String[]{title, text});
        }
        this.setTitle(title);
        if (this.type != Type.AVAILABLE || this.plugins == null || this.plugins.size() < 2) {
            this.setComment(i18n.tr("Version {0}", this.manifest.getVersion().toString()));
        }
        String builddate = this.manifest.getBuildDate();
        String buildnumber = this.manifest.getBuildnumber();
        if (builddate != null && builddate.length() > 0 && buildnumber != null && buildnumber.length() > 0) {
            this.setTooltip(i18n.tr("Build-Datum {0}\nBuildnummer {1}", new String[]{builddate, buildnumber}));
        }
        if (this.type == Type.INSTALLED) {
            Button update = new Button(i18n.tr("Manuell aktualisieren..."), new PluginUpdate(), this.manifest, false, "emblem-package.png");
            update.setEnabled(this.manifest.isInstalled() || error != null);
            this.addButton(update);
            Button delete = new Button(i18n.tr("Plugin l\u00f6schen..."), new PluginUnInstall(), this.manifest, false, "user-trash-full.png");
            try {
                Application.getPluginLoader().canUnInstall(this.manifest);
            }
            catch (ApplicationException ae) {
                delete.setEnabled(false);
            }
            this.addButton(delete);
        } else if (this.type == Type.AVAILABLE && this.plugins != null && this.plugins.size() > 0) {
            PluginDownload download = new PluginDownload(){

                @Override
                public void handleAction(Object context) throws ApplicationException {
                    super.handleAction(PluginDetailPart.this.getSelectedVersion());
                }
            };
            Manifest installed = Application.getPluginLoader().getManifest(this.manifest.getPluginClass());
            String text = "Installieren...";
            if (installed != null) {
                Version vi = installed.getVersion();
                Version vn = this.manifest.getVersion();
                text = "Erneut installieren...";
                if (vi != null && vn != null && vn.compareTo(vi) > 0) {
                    text = "Aktualisieren...";
                }
            }
            Button install = new Button(i18n.tr(text), download, null, false, "document-save.png");
            this.addButton(install);
        } else if (this.type == Type.UPDATE && this.plugins != null && this.plugins.size() > 0) {
            PluginDownload download = new PluginDownload(){

                @Override
                public void handleAction(Object context) throws ApplicationException {
                    super.handleAction(PluginDetailPart.this.getSelectedVersion());
                }
            };
            Button install = new Button(i18n.tr("Aktualisieren..."), download, null, false, "document-save.png");
            this.addButton(install);
        }
    }

    private PluginData getSelectedVersion() {
        if (this.plugins == null || this.plugins.size() == 0) {
            return null;
        }
        if (this.plugins.size() == 1) {
            return this.plugins.get(0);
        }
        Version version = (Version)this.getVersion().getValue();
        for (PluginData p : this.plugins) {
            if (!p.getAvailableVersion().equals(version)) continue;
            return p;
        }
        Logger.warn((String)"unable to determine selected version, using first found");
        return this.plugins.get(0);
    }

    private SelectInput getVersion() {
        if (this.version != null) {
            return this.version;
        }
        ArrayList<Version> versions = new ArrayList<Version>();
        if (this.plugins != null) {
            for (PluginData plugin : this.plugins) {
                versions.add(plugin.getAvailableVersion());
            }
        }
        Collections.sort(versions);
        Collections.reverse(versions);
        this.version = new SelectInput(versions, null);
        this.version.setName(i18n.tr("Zu installierende Version"));
        return this.version;
    }

    @Override
    public Composite extend(InfoPanel.DrawState state, Composite comp, Object context) {
        if (state != null && state == InfoPanel.DrawState.BUTTONS_BEFORE && this.plugins != null && this.plugins.size() > 1) {
            Composite newComp = new Composite(comp, 0);
            newComp.setBackground(comp.getBackground());
            newComp.setBackgroundMode(2);
            newComp.setLayoutData((Object)new GridData(128));
            newComp.setLayout((Layout)new GridLayout(2, false));
            SimpleContainer c = new SimpleContainer(newComp);
            c.addInput(this.getVersion());
            return newComp;
        }
        return super.extend(state, comp, context);
    }

    public static enum Type {
        INSTALLED,
        AVAILABLE,
        UPDATE;

    }
}

